/*
 * definitions for dealing with clients
 */

/*
 * Definitions
 */


/*
 * data for handling a client
 */
struct fms_client_desc {

  struct fms_connection *fcp;		/* connection for this agent */
  struct lf_channel *chp;		/* FMS channel */

  /* incoming message buffers */
  struct fms_msg_header header;
  union lf_client_fms_msg *cl_msgbuf;
  int cl_msgbuf_size;
};

/*
 * prototypes
 */
int fms_init_client_connection(struct fms_connection *fcp);
void fms_client_disconnect(struct fms_client_desc *cdp);
void fms_disconnect_from_client(struct fms_client_desc *cdp);
int fms_client_query_alerts(struct fms_client_desc *cdp);
int fms_client_ack_alert(struct fms_client_desc *cdp);
int fms_alert_count(int show_acked, int show_relics);
int fms_client_query_status(struct fms_client_desc *cdp);
void fms_client_switch_maintenance(struct fms_client_desc *cdp);
void fms_client_query_proximity (struct fms_client_desc *cdp);
